/*
 * Copyright © 2022 Imagination Technologies Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#include "pvr_util.h"

/* Generated by floor(n/log2(10)). This is a compact representation of a
 * log10(2**n) estimation. Estimations of log2(n) +1/-0 are very fast on modern
 * CPUs with clz (or equivalent) instructions, which makes this log2-indexed
 * lookup both compact and fast. Assuming an input of log2(x) +1/-0; this lut
 * should produce an output of ceil(log10(x)) +0/-1.
 */
const uint8_t est_log10_from_log2[64 + 1] = {
   0,  0,  0,  0,  1,  1,  1,  2,  2,  2,  3,  3,  3,  3,  4,  4,  4,
   5,  5,  5,  6,  6,  6,  6,  7,  7,  7,  8,  8,  8,  9,  9,  9,  9,
   10, 10, 10, 11, 11, 11, 12, 12, 12, 12, 13, 13, 13, 14, 14, 14, 15,
   15, 15, 15, 16, 16, 16, 17, 17, 17, 18, 18, 18, 18, 19,
};

/* Generated by 10**n with one exception: we make the first power of ten 0
 * (instead of 1) to ensure a 0-input produces a single digit (instead of no
 * digits).
 */
const uint32_t u32_powers_of_ten[10] = {
   UINT32_C(0),          UINT32_C(10),       UINT32_C(100),
   UINT32_C(1000),       UINT32_C(10000),    UINT32_C(100000),
   UINT32_C(1000000),    UINT32_C(10000000), UINT32_C(100000000),
   UINT32_C(1000000000),
};

/* This is an extension of u32_powers_of_ten to include all possible 64-bit
 * values.
 */
const uint64_t u64_powers_of_ten[20] = {
   UINT64_C(0),
   UINT64_C(10),
   UINT64_C(100),
   UINT64_C(1000),
   UINT64_C(10000),
   UINT64_C(100000),
   UINT64_C(1000000),
   UINT64_C(10000000),
   UINT64_C(100000000),
   UINT64_C(1000000000),
   UINT64_C(10000000000),
   UINT64_C(100000000000),
   UINT64_C(1000000000000),
   UINT64_C(10000000000000),
   UINT64_C(100000000000000),
   UINT64_C(1000000000000000),
   UINT64_C(10000000000000000),
   UINT64_C(100000000000000000),
   UINT64_C(1000000000000000000),
   UINT64_C(10000000000000000000),
};
